﻿using Performance.EntityModels;
using System;
using System.Collections.Generic;
using System.Linq;

namespace Performance.Repository
{
    public partial class PerforReportRepository : PerforRepository<PerReport>
    {
        public PerforReportRepository(PerformanceDbContext context) : base(context)
        {
        }

        /// <summary>
        /// 月群体人均绩效
        /// </summary>
        /// <returns></returns>
        public List<PerReport> GetAvgPerfor(int hospitalid)
        {

            string sql = @"select concat(allot.year,'-',lpad(allot.month,2,'0')) x, positionname y,round(avgvalue,2) value
from res_baiscnorm bc left join per_allot allot on bc.allotid = allot.id where allot.hospitalid = @hospitalid 
order by str_to_date(concat(allot.month, '/', allot.year),'%m/%Y')";
            return DapperQuery(sql, new { hospitalid }).ToList();
        }

        /// <summary>
        /// 人群绩效比
        /// </summary>
        /// <param name="hospitalid"></param>
        /// <returns></returns>
        public List<PerReport> AvgRatio(int hospitalid)
        {
            string sql = @"select concat(allot.year,'-',lpad(allot.month,2,'0')) x, bc.PositionName y,round(bc.AvgValue / rbn.AvgValue,2) value
from res_baiscnorm bc left join res_baiscnorm rbn on bc.allotid = rbn.allotid and rbn.positionname = '临床科室主任人均绩效'
left join per_allot allot on bc.allotid = allot.id where allot.hospitalid = @hospitalid 
order by str_to_date(concat(allot.month, '/', allot.year),'%m/%Y');";
            return DapperQuery(sql, new { hospitalid }).ToList();
        }

        /// <summary>
        /// 门诊患者均次费用
        /// </summary>
        /// <returns></returns>
        public List<PerReport> OutFeeAvg(List<string> date)
        {
            string sql = @"select concat(year,'-',lpad(month,2,'0')) y,deptname x,round(sum(fee) / sum(persontime),2) value from hos_personfee where source = '门诊' and concat(year,'-',lpad(month,2,'0')) in @date group by year,month,deptname order by y asc,value desc;";
            return DapperQuery(sql, new { date }).ToList();
        }

        /// <summary>
        /// 住院患者均次费用
        /// </summary>
        /// <returns></returns>
        public List<PerReport> InpatFeeAvg(List<string> date)
        {
            string sql = @"select concat(year,'-',lpad(month,2,'0')) y,deptname x,round(sum(fee) / sum(persontime),2) value from hos_personfee where source = '住院' and concat(year,'-',lpad(month,2,'0')) in @date group by year,month,deptname order by y asc,value desc;";
            return DapperQuery(sql, new { date }).ToList();
        }

        /// <summary>
        /// 科室药占比
        /// </summary>
        /// <returns></returns>
        public List<PerReport> Medicine(List<string> date)
        {
            string sql = @"select accountingunit x,concat(year,'-',lpad(month,2,'0')) y,round((sum(if(dt.TypeName in 
                ('中成药费','西药费','中草药费'),cellvalue,0)) / sum(cellvalue))*100,2) value from per_allot aot 
                join per_sheet sht on aot.id=sht.allotid join im_data dt on dt.sheetid=sht.id where unittype=1 and sheettype=3 
                and sheetname like '%就诊收入' and ifnull(accountingunit,'') not in ('') and concat(year,'-',lpad(month,2,'0')) 
                in @date group by year,month,accountingunit order by y asc,value desc;";
            return DapperQuery(sql, new { date }).ToList();
        }

        /// <summary>
        /// 科室有效收入占比
        /// </summary>
        /// <returns></returns>
        public List<PerReport> Income(List<string> date)
        {
            string sql = @"select accountingunit x,concat(year,'-',lpad(month,2,'0')) y,round((sum(if(dt.TypeName not in 
                ('中成药费','西药费','中草药费','医材费'),cellvalue,0)) / sum(cellvalue))*100,2) value from per_allot aot 
                join per_sheet sht on aot.id=sht.allotid join im_data dt on dt.sheetid=sht.id where unittype=1 and sheettype=3 
                and sheetname like '%就诊收入' and ifnull(accountingunit,'') not in ('') and concat(year,'-',lpad(month,2,'0')) 
                in @date group by year,month,accountingunit order by y asc,value desc;";
            return DapperQuery(sql, new { date }).ToList();
        }
    }
}
